/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia.network;

import com.xiangcao.xiangcaomengjia.config.SellingBinConfigClient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record PacketTradeList(List<SellingBinConfigClient.TradeEntry> list, boolean reloadSuccess) {
    public PacketTradeList(List<SellingBinConfigClient.TradeEntry> list) {
        this(list, false);
    }

    public static void encode(PacketTradeList pkt, FriendlyByteBuf buf) {
        buf.writeBoolean(pkt.reloadSuccess());
        List<SellingBinConfigClient.TradeEntry> list = pkt.list();
        buf.writeInt(list.size());
        for (SellingBinConfigClient.TradeEntry e : list) {
            buf.m_130070_(e.itemId());
            buf.m_130130_(e.count());
            buf.m_130103_(e.price());
        }
    }

    public static PacketTradeList decode(FriendlyByteBuf buf) {
        boolean reloadSuccess = buf.readBoolean();
        int size = buf.readInt();
        ArrayList<SellingBinConfigClient.TradeEntry> list = new ArrayList<SellingBinConfigClient.TradeEntry>();
        for (int i = 0; i < size; ++i) {
            list.add(new SellingBinConfigClient.TradeEntry(buf.m_130277_(), buf.m_130242_(), buf.m_130258_()));
        }
        return new PacketTradeList(list, reloadSuccess);
    }

    public static void handle(PacketTradeList pkt, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            SellingBinConfigClient.setTradeList(pkt.list());
            if (pkt.reloadSuccess()) {
                try {
                    Class.forName("com.xiangcao.xiangcaomengjia.client.ClientPackets").getMethod("showReloadSuccessMessage", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Show reload message (client)", e);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

